<?php

/**
 * Blog Archive Page
 * المدونة
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'المدونة';
include 'template-parts/breadcrumb.php';

// Sample blog posts data (replace with database/CMS data)
$blog_posts = [
    [
        'id' => 1,
        'title' => 'نشاطات للأطفال 3 سنوات: دليل كيان لدعم ونمو طفلك بشكل سليم!',
        'excerpt' => 'ففي هذه الفترة يبدأ في استكشاف العالم بشكل أوسع، ويزداد فضوله، وتتطور قدراته الحركية والعقلية والاجتماعية بشكل سريع. ولذلك فإن اختيار نشاطات للأطفال 3 سنوات',
        'image' => 'dist/images/blog/blog-1.webp',
        'category' => 'تربية الأطفال',
        'date' => '15 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'nshatat-llatfal-3-snoat'
    ],
    [
        'id' => 2,
        'title' => 'كيف تصنع الأنشطة الفنية فرقًا في نمو طفلك؟',
        'excerpt' => 'هل لاحظت يومًا كيف تؤثر الأنشطة الفنية بمختلف أنواعها على طفلك، سواء كانت (الرسم، الموسيقى، المسرح) وغيرها؟',
        'image' => 'dist/images/blog/blog-2.webp',
        'category' => 'التعليم المبكر',
        'date' => '10 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'importance-of-play'
    ],
    [
        'id' => 3,
        'title' => 'الأمان والرعاية في حضانة فيوتشر كيان - مكان آمن لطفلك',
        'excerpt' => 'إن أكثر ما يبحث عنه الآباء عند اختيار أفضل دور حضانة لأطفالهم أن تكون تتصف بالأمن والرعاية المتكاملة للأطفال، بجانب البحث عن كيفية تنمية مهارات الطفل، حيث أن الأمن',
        'image' => 'dist/images/blog/blog-3.webp',
        'category' => 'نصائح تربوية',
        'date' => '5 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'preparing-for-school'
    ],
    [
        'id' => 4,
        'title' => 'تطوير المهارات الاجتماعية عند الأطفال في فيوتشر كيان أفضل حضانة أطفال بالرياض.',
        'excerpt' => 'تتعدد مزايا تنمية مهارات للاطفال وخاصة المهارات الإجتماعية، لذلك يسعى الآباء إلى إلتحاق أطفالهم منذ الصغر إلى دور الحضانة حيث أن الحضانة قادرة على تنمية القدرات',
        'image' => 'dist/images/blog/blog-4.webp',
        'category' => 'تعليم اللغات',
        'date' => '1 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'early-language-learning'
    ],
];

// Categories for sidebar
$categories = [
    ['name' => 'تربية الأطفال', 'count' => 12],
    ['name' => 'التعليم المبكر', 'count' => 8],
    ['name' => 'نصائح تربوية', 'count' => 15],
    ['name' => 'تعليم اللغات', 'count' => 6],
    ['name' => 'صحة الطفل', 'count' => 10],
    ['name' => 'أنشطة منزلية', 'count' => 9],
];
?>


<!-- ==================== BLOG SECTION ==================== -->
<section class="gradient-section relative overflow-hidden pt-20">


    <div class="text-center max-w-4xl mx-auto">
        <p class="text-primary-600 text-base md:text-lg mb-4">مقالات ونصائح</p>
        <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-6">
            المدونة
        </h1>
    </div>

    <div class="pt-6 pb-12">
        <div class="container">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">

                <!-- Blog Posts Grid -->
                <div class="lg:col-span-3">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <?php foreach ($blog_posts as $post): ?>
                            <article class="bg-white rounded-3xl overflow-hidden group hover:shadow-lg transition-all duration-300">
                                <!-- Post Image -->
                                <a href="blog-single.php?slug=<?php echo htmlspecialchars($post['slug']); ?>" class="block relative overflow-hidden aspect-[16/10]">
                                    <img src="<?php echo htmlspecialchars($post['image']); ?>"
                                        alt="<?php echo htmlspecialchars($post['title']); ?>"
                                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                                        onerror="this.src='https://placehold.co/600x400/E0F5FF/07394D?text=<?php echo urlencode($post['title']); ?>'">
                                    <!-- Category Badge -->
                                    <span class="absolute top-4 right-4 px-3 py-1 bg-secondary-600 text-white text-xs font-bold rounded-full">
                                        <?php echo htmlspecialchars($post['category']); ?>
                                    </span>
                                </a>

                                <!-- Post Content -->
                                <div class="p-6">
                                    <!-- Meta -->
                                    <div class="flex items-center gap-4 text-sm text-gray-500 mb-3">
                                        <span class="flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                            <?php echo htmlspecialchars($post['date']); ?>
                                        </span>
                                        <span class="flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                            </svg>
                                            <?php echo htmlspecialchars($post['author']); ?>
                                        </span>
                                    </div>

                                    <!-- Title -->
                                    <h2 class="text-xl font-bold text-gray-900 mb-3 line-clamp-2 group-hover:text-secondary-600 transition-colors">
                                        <a href="blog-single.php?slug=<?php echo htmlspecialchars($post['slug']); ?>">
                                            <?php echo htmlspecialchars($post['title']); ?>
                                        </a>
                                    </h2>

                                    <!-- Excerpt -->
                                    <p class="text-gray-600 text-sm leading-relaxed line-clamp-3 mb-4">
                                        <?php echo htmlspecialchars($post['excerpt']); ?>
                                    </p>

                                    <!-- Read More -->
                                    <a href="blog-single.php?slug=<?php echo htmlspecialchars($post['slug']); ?>"
                                        class="inline-flex items-center gap-2 text-secondary-600 font-bold text-sm hover:text-secondary-800 transition-colors">
                                        <span>اقرأ المزيد</span>
                                        <svg class="w-4 h-4 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </div>

                    <!-- Pagination -->
                    <div class="flex items-center justify-center gap-2 mt-12">
                        <a href="#" class="w-10 h-10 rounded-full bg-white flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors">
                            <svg class="w-5 h-5 ltr:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full bg-secondary-600 text-white flex items-center justify-center font-bold">1</a>
                        <a href="#" class="w-10 h-10 rounded-full bg-white flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors font-bold">2</a>
                        <a href="#" class="w-10 h-10 rounded-full bg-white flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors font-bold">3</a>
                        <span class="text-gray-400">...</span>
                        <a href="#" class="w-10 h-10 rounded-full bg-white flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors font-bold">10</a>
                        <a href="#" class="w-10 h-10 rounded-full bg-white flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors">
                            <svg class="w-5 h-5 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Sidebar -->
                <aside class="lg:col-span-1">
                    <!-- Search Box -->
                    <div class="bg-white rounded-3xl p-6 shadow-sm mb-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">البحث</h3>
                        <form action="blog.php" method="GET" class="relative">
                            <input type="text" name="search" placeholder="ابحث في المدونة..."
                                class="w-full px-4 py-3 pl-12 ltr:pr-12 ltr:pl-3 rounded-xl text-start border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none">
                            <button type="submit" class="absolute end-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-secondary-600 transition-colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </button>
                        </form>
                    </div>

                    <!-- Categories -->
                    <div class="bg-white rounded-3xl p-6 shadow-sm mb-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">التصنيفات</h3>
                        <ul class="space-y-3">
                            <?php foreach ($categories as $category): ?>
                                <li>
                                    <a href="blog.php?category=<?php echo urlencode($category['name']); ?>"
                                        class="flex items-center justify-between text-gray-600 hover:text-secondary-600 transition-colors">
                                        <span><?php echo htmlspecialchars($category['name']); ?></span>
                                        <span class="w-6 h-6 rounded-full bg-gray-100 flex items-center justify-center text-xs font-bold text-gray-500">
                                            <?php echo $category['count']; ?>
                                        </span>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>

                    <!-- Recent Posts -->
                    <div class="bg-white rounded-3xl p-6 shadow-sm mb-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">أحدث المقالات</h3>
                        <div class="space-y-4">
                            <?php foreach (array_slice($blog_posts, 0, 3) as $post): ?>
                                <a href="blog-single.php?slug=<?php echo htmlspecialchars($post['slug']); ?>"
                                    class="flex gap-3 group">
                                    <div class="w-16 h-16 rounded-xl overflow-hidden flex-shrink-0 border-gray-200 border">
                                        <img src="<?php echo htmlspecialchars($post['image']); ?>"
                                            alt="<?php echo htmlspecialchars($post['title']); ?>"
                                            class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300"
                                            onerror="this.src='https://placehold.co/100x100/E0F5FF/07394D?text=Blog'">
                                    </div>
                                    <div class="flex-1">
                                        <h4 class="text-sm font-bold text-gray-900 line-clamp-2 group-hover:text-secondary-600 transition-colors">
                                            <?php echo htmlspecialchars($post['title']); ?>
                                        </h4>
                                        <p class="text-xs text-gray-500 mt-1"><?php echo htmlspecialchars($post['date']); ?></p>
                                    </div>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>

                </aside>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
</section>

<?php include 'footer.php'; ?>