<?php

/**
 * Blog Single Post Page
 * صفحة المقال
 */

include 'header.php';

// Get post slug from URL
$slug = isset($_GET['slug']) ? $_GET['slug'] : '';

// Sample post data (replace with database/CMS data)
$post = [
    'id' => 1,
    'title' => 'نشاطات للأطفال 3 سنوات: دليل كيان لدعم ونمو طفلك بشكل سليم!',
    'excerpt' => 'ففي هذه الفترة يبدأ في استكشاف العالم بشكل أوسع، ويزداد فضوله، وتتطور قدراته الحركية والعقلية والاجتماعية بشكل سريع. ولذلك فإن اختيار نشاطات للأطفال 3 سنوات',
    'content' => '
            <h2>1- ركن المسرح: مساحة للتعبير والخيال وبناء الثقة</h2>
            
            <p>ركن المسرح من أهم النشاطات المتاحة للأطفال 3 سنوات، لأنه يوفر بيئة تفاعلية تساعد الطفل على التعبير عن نفسه بطريقة طبيعية وسلسة.</p>

            <p>في هذا العمر قد يبدأ الطفل في تقليد الشخصيات التي يراها، أو يحاول استخدام صوته ولغة جسده للتواصل. من هنا يأتي دور المسرح الذي يساعد على:</p>

            <ul>
                <li>تطوير مهارات اللغة والنطق من خلال التكرار والتمثيل.</li>
                <li>تعزيز الثقة بالنفس وتشجيع الطفل على الوقوف أمام الآخرين.</li>
                <li>فهم المشاعر والتعبير عنها عبر الأدوار البسيطة.</li>
                <li>تنمية الخيال والإبداع من خلال ارتداء الأزياء وتجسيد الشخصيات.</li>
                <li>تقوية المهارات الاجتماعية من خلال التمثيل الجماعي.</li>
            </ul>

            <p>ركن المسرح في كيان ليس مجرد مساحة للعب، بل هو تجربة تعليمية متكاملة تجعل الطفل أكثر جرأة وقدرة على التواصل. هذا النوع من الأنشطة يفتح الباب أمام الطفل لاستكشاف شخصيته وتطوير قدراته بطريقة آمنة وممتعة.</p>

            <h2>2- ركن الرسم والفنون: تطوير المهارات الحركية الدقيقة والإبداع</h2>

            <p>الفنون جزء أساسي من أي برنامج يركز على نشاطات للأطفال 3 سنوات، لأنها تُعدّ من أقوى الأنشطة التي تطور المهارات الحركية الدقيقة وتفتح المجال أمام الإبداع البصري.</p>

            <p>في كيان، يقدم ركن الرسم والفنون مجموعة واسعة من الأنشطة، مثل:</p>

            <ul>
                <li>التلوين بالألوان المائية والأقلام الشمعية.</li>
                <li>القص واللصق لتقوية التحكم في الأصابع.</li>
                <li>تشكيل الصلصال لصنع أشكال بسيطة.</li>
                <li>صنع أعمال فنية باستخدام قصاصات الورق والخامات الآمنة.</li>
            </ul>

            <p>الفنون تساعد الطفل على فهم الألوان والمساحات والأشكال، وتشجعه على التفكير الإبداعي، كما تمنحه فرصة للتعبير عن مشاعره وأفكاره بدون كلمات.</p>

            <h2>3- النادي الرياضي: تنمية القوة البدنية والمهارات الحركية</h2>

            <p>الحركة عنصر أساسي في نمو الطفل بعمر 3 سنوات، ولذلك يركز كيان على توفير نادي رياضي مناسب وآمن يتيح للطفل مساحة للتفريغ الحركي بطريقة منظمة.</p>

            <p>يستطيع طفلك في هذا الركن ممارسة:</p>

            <ul>
                <li>القفز</li>
                <li>الجري</li>
                <li>ألعاب الكرة الخفيفة</li>
                <li>حركات تنشط الجسم</li>
            </ul>

            <p>هذه الأنشطة لا تُعد مجرد لعب، بل هي أنشطة تعليمية تساهم في:</p>

            <ul>
                <li>تقوية العضلات.</li>
                <li>تحسين التوازن والتنسيق الحركي.</li>
                <li>تطوير مهارات التركيز والانتباه.</li>
                <li>زيادة الثقة بالنفس والجرأة الحركية.</li>
                <li>تعزيز الطاقة الإيجابية وتنظيم الحركة.</li>
            </ul>

            <h2>4- ركن الأنشطة التعليمية: تطوير الذكاء والتفكير المنطقي</h2>

            <p>من المهم في هذه المرحلة تقديم أنشطة تعليمية للأطفال 3 سنوات بطريقة تفاعلية وبسيطة، دون ضغط أو تعقيد.</p>

            <p>في كيان صُمم ركن التعليم ليجمع بين اللعب والمعرفة، ويقدم أنشطة تساعد الطفل على:</p>

            <ul>
                <li>تنمية التفكير المنطقي.</li>
                <li>تقوية الذاكرة والانتباه.</li>
                <li>تطوير مهارة حل المشكلات.</li>
                <li>بناء المفاهيم الأولية مثل الأرقام والألوان والأشكال.</li>
                <li>فهم العلاقات بين الأشياء من خلال ألعاب البازل والتركيب.</li>
                <li>تعلم مهارات سلوكية مثل ترتيب الأشياء والتنظيم.</li>
            </ul>

            <p>يشمل هذا الركن:</p>

            <ul>
                <li>ألعاب الفرز</li>
                <li>العد بالمكعبات</li>
                <li>ألعاب التعرف على الأصوات والصور</li>
                <li>قصص مصورة تفاعلية</li>
            </ul>

            <h2>5- أنشطة خارجية آمنة: استكشاف الطبيعة والحركة الحرة</h2>

            <p>عندما يكون الطقس مناسبًا، يتم تنظيم أنشطة خارجية داخل مساحات آمنة تسمح للأطفال:</p>

            <ul>
                <li>باللعب بالرمال</li>
                <li>اللعب بالماء</li>
                <li>الجري في الهواء الطلق</li>
                <li>مطاردة الفقاعات</li>
                <li>استكشاف النباتات والألوان في الطبيعة</li>
            </ul>

            <h2>كيف تختارين النشاط المناسب لطفلك؟</h2>

            <ul>
                <li>راقبي ميول طفلك وحددي ما يستمتع به أكثر.</li>
                <li>اختاري أنشطة متنوعة تجمع بين الفن والحركة والتعليم.</li>
                <li>وفّري بيئة آمنة ومشجعة.</li>
                <li>دعي الطفل يستكشف ويجرب بدون ضغط.</li>
                <li>اختاري مكانًا يجمع بين الأنشطة المختلفة مثل كيان لتوفير تجربة متكاملة.</li>
            </ul>

            <h2>خاتمة</h2>

            <p>في عمر الثلاث سنوات، يحتاج الطفل إلى بيئة غنية بالأنشطة التي تلبي احتياجاته وتدعم فضوله ونموه الطبيعي. تجمع الأركان المتوفرة في كيان بين نشاطات للأطفال 3 سنوات التي تعزز الإبداع والذكاء والمهارات الحركية والاجتماعية، داخل مساحة آمنة وواضحة ومناسبة لهذا العمر.</p>

            <p>التنوع الموجود بين ركن المسرح، الفنون، النادي الرياضي، والأنشطة التعليمية يجعل التجربة متكاملة وممتعة في نفس الوقت، ويمنح الطفل فرصة لتجربة كل ما يحتاجه في هذه المرحلة المهمة من حياته.</p>

            <p>إذا كنتِ تبحثين عن بيئة تساعد طفلك على النمو بثقة ومرح، فكل هذه الأركان موجودة ومهيّأة في كيان ليستفيد منها طفلك بأفضل شكل ممكن.</p>

            <h2>أسئلة شائعة</h2>

            <h3>هل يملك طفلك مهارات في عمر 3 سنوات؟</h3>
            <p>نعم، يتمكن الطفل من الجري والقفز، يبدأ في تكوين جمل أطول، يستطيع التعبير عن المشاعر، ويتطور لديه التركيز، كما يستوعب التعليمات البسيطة ويبدأ في اللعب التعاوني.</p>

            <h3>هل هناك نشاط محدد لطفل عمره 3 سنوات؟</h3>
            <p>لا، أفضل نشاط هو الذي يجمع بين التعلم واللعب مثل الرسم، المسرح، البازل، والأنشطة الحركية—كلاً منها موجودة ضمن أركان كيان بشكل آمن وممتع.</p>
',
    'image' => 'dist/images/blog/blog-3.webp',
    'category' => 'تربية الأطفال',
    'date' => '15 ديسمبر 2025',
    'author' => 'فريق كيان',
    'author_image' => 'dist/images/team/author.webp',
    'reading_time' => '5 دقائق',
    'slug' => 'helping-child-social-skills',
    'tags' => ['تربية', 'مهارات اجتماعية', 'تنمية الطفل', 'تعليم']
];

// Related posts
$related_posts = [
    [
        'id' => 1,
        'title' => 'نشاطات للأطفال 3 سنوات: دليل كيان لدعم ونمو طفلك بشكل سليم!',
        'excerpt' => 'ففي هذه الفترة يبدأ في استكشاف العالم بشكل أوسع، ويزداد فضوله، وتتطور قدراته الحركية والعقلية والاجتماعية بشكل سريع. ولذلك فإن اختيار نشاطات للأطفال 3 سنوات',
        'image' => 'dist/images/blog/blog-1.webp',
        'category' => 'تربية الأطفال',
        'date' => '15 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'nshatat-llatfal-3-snoat'
    ],
    [
        'id' => 2,
        'title' => 'كيف تصنع الأنشطة الفنية فرقًا في نمو طفلك؟',
        'excerpt' => 'هل لاحظت يومًا كيف تؤثر الأنشطة الفنية بمختلف أنواعها على طفلك، سواء كانت (الرسم، الموسيقى، المسرح) وغيرها؟',
        'image' => 'dist/images/blog/blog-2.webp',
        'category' => 'التعليم المبكر',
        'date' => '10 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'importance-of-play'
    ],
    [
        'id' => 3,
        'title' => 'الأمان والرعاية في حضانة فيوتشر كيان - مكان آمن لطفلك',
        'excerpt' => 'إن أكثر ما يبحث عنه الآباء عند اختيار أفضل دور حضانة لأطفالهم أن تكون تتصف بالأمن والرعاية المتكاملة للأطفال، بجانب البحث عن كيفية تنمية مهارات الطفل، حيث أن الأمن',
        'image' => 'dist/images/blog/blog-3.webp',
        'category' => 'نصائح تربوية',
        'date' => '5 ديسمبر 2025',
        'author' => 'فريق كيان',
        'slug' => 'preparing-for-school'
    ],
];

// Breadcrumb
$breadcrumb_title = $post['title'];
$breadcrumb_items = [
    ['title' => 'المدونة', 'url' => 'blog.php']
];
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== ARTICLE HEADER ==================== -->
<section class="pt-16 pb-8 bg-white">
    <div class="container">
        <div class="max-w-4xl mx-auto">
            <!-- Category -->
            <div class="text-center mb-4">
                <a href="blog.php?category=<?php echo urlencode($post['category']); ?>"
                    class="inline-block px-4 py-1 bg-secondary-100 text-secondary-700 text-sm font-bold rounded-full hover:bg-secondary-200 transition-colors">
                    <?php echo htmlspecialchars($post['category']); ?>
                </a>
            </div>

            <!-- Title -->
            <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-[#07394D] text-center !leading-snug mb-6">
                <?php echo htmlspecialchars($post['title']); ?>
            </h1>

            <!-- Meta -->
            <div class="flex flex-wrap items-center justify-center gap-4 text-sm text-gray-500 mb-8">
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    <?php echo htmlspecialchars($post['date']); ?>
                </span>
                <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <?php echo htmlspecialchars($post['reading_time']); ?> للقراءة
                </span>
                <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    <?php echo htmlspecialchars($post['author']); ?>
                </span>
            </div>

            <!-- Featured Image -->
            <div class="rounded-3xl overflow-hidden shadow-lg">
                <img src="<?php echo htmlspecialchars($post['image']); ?>"
                    alt="<?php echo htmlspecialchars($post['title']); ?>"
                    class="w-full h-auto aspect-[16/9] object-cover"">
            </div>
        </div>
    </div>
</section>

<!-- ==================== ARTICLE CONTENT ==================== -->
<section class=" py-12 bg-white">
                <div class="container">
                    <div class="max-w-4xl mx-auto">
                        <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
                            <!-- Share Sidebar (Desktop) -->
                            <aside class="hidden lg:block lg:col-span-1">
                                <div class="sticky top-24 flex flex-col gap-3">
                                    <span class="text-sm text-gray-500 font-medium mb-2">شارك:</span>
                                    <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>&text=<?php echo urlencode($post['title']); ?>"
                                        target="_blank"
                                        class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#1DA1F2] hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z" />
                                        </svg>
                                    </a>
                                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                        target="_blank"
                                        class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#1877F2] hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                                        </svg>
                                    </a>
                                    <a href="https://wa.me/?text=<?php echo urlencode($post['title'] . ' - https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                        target="_blank"
                                        class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#128c7e] hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" />
                                        </svg>
                                    </a>
                                    <a href="mailto:?subject=<?php echo urlencode($post['title']); ?>&body=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                        class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                        </svg>
                                    </a>
                                </div>
                            </aside>

                            <!-- Article Content -->
                            <article class="lg:col-span-11 prose prose-base max-w-none
                    prose-headings:text-[#07394D] prose-headings:font-bold
                    prose-h2:text-2xl prose-h2:mt-8 prose-h2:mb-4
                    prose-h3:text-xl prose-h3:mt-6 prose-h3:mb-3
                    prose-p:text-gray-700 prose-p:leading-relaxed prose-p:mb-4
                    prose-ul:my-4 prose-ul:pr-6
                    prose-li:text-gray-700 prose-li:mb-2
                    prose-blockquote:border-r-4 prose-blockquote:border-secondary-500 prose-blockquote:pr-4 prose-blockquote:mr-0
                    prose-blockquote:bg-secondary-50 prose-blockquote:py-4 prose-blockquote:rounded-l-xl
                    prose-blockquote:text-gray-700 prose-blockquote:italic prose-blockquote:font-medium
                    prose-a:text-secondary-600 prose-a:no-underline hover:prose-a:underline">
                                <?php echo $post['content']; ?>
                            </article>
                        </div>

                        <!-- Tags -->
                        <div class="mt-12 pt-8 border-t border-gray-100">
                            <div class="flex flex-wrap items-center gap-3">
                                <span class="text-gray-600 font-medium">الوسوم:</span>
                                <?php foreach ($post['tags'] as $tag): ?>
                                    <a href="blog.php?tag=<?php echo urlencode($tag); ?>"
                                        class="px-4 py-2 bg-gray-100 text-gray-600 text-sm rounded-full hover:bg-secondary-100 hover:text-secondary-700 transition-colors">
                                        #<?php echo htmlspecialchars($tag); ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <!-- Share (Mobile) -->
                        <div class="lg:hidden mt-8 pt-8 border-t border-gray-100">
                            <h4 class="text-gray-600 font-medium mb-4">شارك المقال:</h4>
                            <div class="flex gap-3">
                                <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>&text=<?php echo urlencode($post['title']); ?>"
                                    target="_blank"
                                    class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#1DA1F2] hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z" />
                                    </svg>
                                </a>
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                    target="_blank"
                                    class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#1877F2] hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                                    </svg>
                                </a>
                                <a href="https://wa.me/?text=<?php echo urlencode($post['title'] . ' - https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                    target="_blank"
                                    class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-[#128c7e] hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" />
                                    </svg>
                                </a>
                                <a href="mailto:?subject=<?php echo urlencode($post['title']); ?>&body=<?php echo urlencode('https://futurekayan.com/blog-single.php?slug=' . $post['slug']); ?>"
                                    class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 hover:bg-secondary-600 hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <!-- Author Box -->
                        <div class="mt-12 p-6 sm:p-8 bg-gray-50 rounded-3xl">
                            <div class="flex flex-col sm:flex-row items-center sm:items-start gap-6">
                                <div class="w-20 h-20 rounded-full overflow-hidden flex-shrink-0 bg-gradient-to-r rtl:bg-gradient-to-l from-secondary-600 to-secondary-800 flex items-center justify-center">
                                    <img src="<?php echo htmlspecialchars($post['author_image']); ?>"
                                        alt="<?php echo htmlspecialchars($post['author']); ?>"
                                        class="w-full h-full object-cover"
                                        onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                    <span class="text-white text-2xl font-bold hidden"><?php echo mb_substr($post['author'], 0, 1); ?></span>
                                </div>
                                <div class="flex-1 text-center sm:text-start">
                                    <h4 class="text-xl font-bold text-gray-900 mb-2"><?php echo htmlspecialchars($post['author']); ?></h4>
                                    <p class="text-gray-600 leading-relaxed">
                                        نحن فريق متخصص في مجال رعاية وتعليم الأطفال، نسعى لمشاركة أحدث المعلومات والنصائح التربوية مع الآباء والأمهات لمساعدتهم في تنشئة أبنائهم بأفضل الطرق.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Post Navigation -->
                        <div class="mt-12 grid grid-cols-1 md:grid-cols-2 gap-4">
                            <a href="#" class="group p-6 bg-gray-50 rounded-2xl hover:bg-secondary-50 transition-colors text-start">
                                <span class="text-sm text-gray-500 flex items-center gap-2 mb-2">
                                    <svg class="w-4 h-4 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                                    </svg>
                                    المقال السابق
                                </span>
                                <span class="font-bold text-gray-900 group-hover:text-secondary-600 transition-colors">أهمية اللعب في تنمية ذكاء الطفل</span>
                            </a>
                            <a href="#" class="group p-6 bg-gray-50 rounded-2xl hover:bg-secondary-50 transition-colors text-end">
                                <span class="text-sm text-gray-500 flex items-center justify-end gap-2 mb-2">
                                    المقال التالي
                                    <svg class="w-4 h-4 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </span>
                                <span class="font-bold text-gray-900 group-hover:text-secondary-600 transition-colors">نصائح لتحضير طفلك للعام الدراسي الجديد</span>
                            </a>
                        </div>
                    </div>
                </div>
</section>

<!-- ==================== RELATED POSTS ==================== -->
<section class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-4">
                    مقالات ذات صلة
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg max-w-2xl mx-auto">
                    قد تهمك أيضاً هذه المقالات المتعلقة بنفس الموضوع
                </p>
            </div>

            <!-- Related Posts Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <?php foreach ($related_posts as $rpost): ?>
                    <article class="bg-white rounded-3xl shadow-sm overflow-hidden group hover:shadow-lg transition-all duration-300">
                        <!-- Post Image -->
                        <a href="blog-single.php?slug=<?php echo htmlspecialchars($rpost['slug']); ?>" class="block relative overflow-hidden aspect-[16/10]">
                            <img src="<?php echo htmlspecialchars($rpost['image']); ?>"
                                alt="<?php echo htmlspecialchars($rpost['title']); ?>"
                                class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                                >
                            <!-- Category Badge -->
                            <span class="absolute top-4 right-4 px-3 py-1 bg-secondary-600 text-white text-xs font-bold rounded-full">
                                <?php echo htmlspecialchars($rpost['category']); ?>
                            </span>
                        </a>

                        <!-- Post Content -->
                        <div class="p-6">
                            <!-- Date -->
                            <p class="text-sm text-gray-500 mb-3 flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                                <?php echo htmlspecialchars($rpost['date']); ?>
                            </p>

                            <!-- Title -->
                            <h3 class="text-lg font-bold text-gray-900 line-clamp-2 group-hover:text-secondary-600 transition-colors">
                                <a href="blog-single.php?slug=<?php echo htmlspecialchars($rpost['slug']); ?>">
                                    <?php echo htmlspecialchars($rpost['title']); ?>
                                </a>
                            </h3>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>

            <!-- View All Link -->
            <div class="text-center mt-10">
                <a href="blog.php"
                    class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-white text-secondary-700 text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl active:scale-[0.97]">
                    <span>عرض جميع المقالات</span>
                    <svg class="w-5 h-5 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                    </svg>
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
</section>

<?php include 'footer.php'; ?>