<?php

/**
 * About Page Template
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'عن كيان';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="container">
        <div class="text-center max-w-3xl mx-auto">
            <p class="text-primary-600 text-base md:text-lg mb-4">تعرف علينا</p>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                عن مركز <span class="text-secondary-700">كيان المستقبل</span>
            </h1>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg">
                نحن نؤمن بأن كل طفل يحمل في داخله بذرة التميز، ومهمتنا هي رعاية هذه البذرة لتنمو وتزهر
            </p>
        </div>
    </div>
</section>

<!-- ==================== OUR STORY SECTION ==================== -->
<section id="our-story" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">
                <!-- Image -->
                <div class="lg:w-1/2">
                    <div class="relative">
                        <img src="dist/images/about.jpg" alt="قصتنا" class="rounded-3xl w-full object-cover">
                        <div class="absolute -bottom-4 -left-4 w-24 h-24 bg-gradient-to-r from-primary-600 to-primary-800 rounded-2xl -z-10"></div>
                        <div class="absolute -top-4 -right-4 w-16 h-16 bg-gradient-to-r from-secondary-600 to-secondary-800 rounded-xl -z-10"></div>
                    </div>
                </div>

                <!-- Content -->
                <div class="lg:w-1/2 text-center lg:text-start">
                    <p class="text-primary-600 text-base md:text-lg mb-4">قصتنا</p>
                    <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-secondary-900 mb-6">
                        رحلة نحو <span class="text-secondary-800">التميز</span>
                    </h2>
                    <p class="text-gray-700 text-sm sm:text-base leading-relaxed mb-6">
                        تأسس مركز كيان المستقبل برؤية واضحة تهدف إلى بناء جيل طموح يكون قاعدة أساسية لمستقبل معرفي باهر ذو فكر مضيء وأهداف واضحة وطموحة.
                    </p>
                    <p class="text-gray-700 text-sm sm:text-base leading-relaxed mb-8">
                        نحن نؤمن بأن السنوات الأولى من حياة الطفل هي الأكثر أهمية في تشكيل شخصيته ومستقبله، لذلك نحرص على توفير بيئة آمنة ومحفزة تساعد الأطفال على اكتشاف قدراتهم وتطوير مهاراتهم.
                    </p>
                    <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2">

                        <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                                <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                            <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                        </a>

                        <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== VISION & MISSION SECTION ==================== -->
<section id="vision-mission" class="py-12 bg-white">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-10">
            <p class="text-primary-600 text-base md:text-lg mb-4">رؤيتنا ورسالتنا</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                نبني المستقبل <span class="text-secondary-800">معاً</span>
            </h2>
        </div>

        <!-- Cards Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Vision Card -->
            <div class="bg-gradient-to-br from-primary-50 to-secondary-50 rounded-3xl p-6 lg:p-12 duration-300">
                <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-secondary-900 mb-4">رؤيتنا</h3>
                <p class="text-gray-700 leading-relaxed">
                    أن نكون المركز الرائد في ضيافة الأطفال بالمملكة، ونموذجًا يُحتذى به في الرعاية والتعليم لبناء جيل مبدع وواعٍ.
                </p>
            </div>

            <!-- Mission Card -->
            <div class="bg-gradient-to-br from-secondary-50 to-primary-50 rounded-3xl p-6 lg:p-12 duration-300">
                <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-secondary-600 to-secondary-800 flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-secondary-900 mb-4">رسالتنا</h3>
                <p class="text-gray-700 leading-relaxed">
                    توفير بيئة آمنة ومحفزة تجمع بين الرعاية الشاملة والتعليم الترفيهي، مع التركيز على تنمية المهارات الذهنية والاجتماعية والحركية للأطفال.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>