<?php
/**
 * 404 Error Page
 * مركز كيان المستقبل - صفحة الخطأ
 */

include 'header.php';
?>

<!-- ==================== BREADCRUMB ==================== -->
<section class="bg-gradient-to-r from-primary-50 to-secondary-50 py-4">
    <div class="container mx-auto px-4">
        <nav class="flex items-center justify-start gap-2 text-sm">
            <a href="index.php" class="text-secondary-700 hover:text-primary-600 transition-colors flex items-center gap-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                <span>الرئيسية</span>
            </a>
            <svg class="w-4 h-4 text-gray-400 rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
            </svg>
            <span class="text-primary-600 font-bold">صفحة غير موجودة</span>
        </nav>
    </div>
</section>

<!-- ==================== 404 CONTENT ==================== -->
<section class="py-16 md:py-24 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto text-center">

            <!-- 404 Illustration -->
            <div class="relative mb-8">
                <div class="text-[150px] md:text-[200px] font-bold text-primary-100 leading-none select-none">
                    404
                </div>
                <div class="absolute inset-0 flex items-center justify-center">
                    <div class="animate-float">
                        <svg class="w-32 h-32 md:w-40 md:h-40 text-primary-500" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <circle cx="12" cy="12" r="10"></circle>
                            <path d="M8 15s1.5-2 4-2 4 2 4 2" stroke-linecap="round"></path>
                            <line x1="9" y1="9" x2="9.01" y2="9" stroke-width="3" stroke-linecap="round"></line>
                            <line x1="15" y1="9" x2="15.01" y2="9" stroke-width="3" stroke-linecap="round"></line>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Error Message -->
            <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-primary-900 mb-4">
                عذراً! الصفحة غير موجودة
            </h1>
            <p class="text-gray-600 text-lg md:text-xl mb-8 leading-relaxed">
                يبدو أن الصفحة التي تبحث عنها قد انتقلت أو لم تعد موجودة.
                <br class="hidden md:block">
                لا تقلق، يمكنك العودة للصفحة الرئيسية واستكشاف المزيد!
            </p>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <a href="index.php" class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 text-white font-bold transition-all duration-300 hover:scale-105 hover:shadow-xl">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    <span>العودة للرئيسية</span>
                </a>
                <a href="javascript:history.back()" class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full border-2 border-secondary-600 text-secondary-700 font-bold transition-all duration-300 hover:bg-secondary-600 hover:text-white">
                    <svg class="w-5 h-5 rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
                    </svg>
                    <span>الصفحة السابقة</span>
                </a>
            </div>

            <!-- Decorative Elements -->
            <div class="mt-16 flex items-center justify-center gap-8 opacity-50">
                <div class="w-16 h-16 rounded-full bg-primary-100 animate-pulse"></div>
                <div class="w-12 h-12 rounded-full bg-secondary-100 animate-pulse" style="animation-delay: 0.2s;"></div>
                <div class="w-8 h-8 rounded-full bg-primary-200 animate-pulse" style="animation-delay: 0.4s;"></div>
            </div>

        </div>
    </div>
</section>

<?php
include 'template-parts/footer.php';
?>
